// By EVOLVED
// www.evolved-software.com

#include "settings.fx"

//--------------
// un-tweaks
//--------------
   float4x4 ViewProj; 
   float4x4 ViewInv;
   float4x4 ViewProjInv;

//-------------
// tweaks
//--------------
   float2 ViewSize;
   float Radius=10.0;
   float Strength=2.0;
   float3 SamplesOffset[16]={float3(0.355512,-0.709318,-0.102371),
	                     float3(0.534186,0.71511,-0.115167),
	                     float3(-0.87866,0.157139,-0.115167),
	                     float3(0.140679,-0.475516,-0.0639818),
	                     float3(-0.0796121,0.158842,-0.677075),
	                     float3(-0.0759516,-0.101676,-0.483625),
	                     float3(0.12493,-0.0223423,-0.483625),
	                     float3(-0.0720074,0.243395,-0.967251),
	                     float3(-0.207641,0.414286,0.187755),
	                     float3(-0.277332,-0.371262,0.187755),
	                     float3(0.63864,-0.114214,0.262857),
	                     float3(-0.184051,0.622119,0.262857),
	                     float3(0.110007,-0.219486,0.435574),
	                     float3(0.235085,0.314707,0.696918),
	                     float3(-0.290012,0.0518654,0.522688),
	                     float3(0.0975089,-0.329594,0.609803)};

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
         Texture=<RenderTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture DepthTexture <string Name = " ";>;
   sampler DepthSampler=sampler_state 
      {
         Texture=<DepthTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture NoiseTexture <string Name = "";>;
   sampler NoiseSampler=sampler_state 
      {
         Texture=<NoiseTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
         float4 Pos:POSITION;
     };
   struct OutPut
     {
         float4 Pos:POSITION; 
         float4 Tex:TEXCOORD0;
         float4 ViewCoord:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
         OutPut OUT;
         OUT.Pos=IN.Pos;
         OUT.Tex.xy=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewSize;
         OUT.Tex.zw=(OUT.Tex.xy/ViewSize.xy)/64.0;
	 OUT.ViewCoord=float4(OUT.Tex.x*2.0-1.0,-(OUT.Tex.y*2.0-1.0),0.0,1.0);
	 OUT.ViewCoord.xyz=mul(OUT.ViewCoord,ViewProjInv).xyz;
         return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
      {
         float Occlude=0.0;
         float Depth=tex2Dlod(RenderSampler,IN.Tex).w;
         float3 WorldPos=normalize(IN.ViewCoord.xyz)*Depth;
         float3 Normals=normalize(cross(ddx(WorldPos),ddy(WorldPos)));
         if(Depth<64000.0) {
          #if SSAO == 1
           WorldPos=ViewInv[3].xyz+WorldPos*2.0;
           float3 Noise=tex2Dlod(NoiseSampler,IN.Tex.zwww)-0.5;
           float Bias=0.0025+Depth*0.005;
           float DepthRadius=Radius+Bias*10.0;
           for (int i=0; i < 16; i++) {
            float3 Hemisphere=reflect(SamplesOffset[i],Noise);
            if(dot(Hemisphere,Normals)<0.2) Hemisphere +=Normals;
            float4 Proj=mul(float4(WorldPos+Hemisphere*DepthRadius,1.0),ViewProj);
            Proj.xy=(Proj.xy/Proj.w)*float2(0.5,-0.5)+0.5;
            float Depth=tex2Dlod(DepthSampler,Proj).w*2.0;
            float zDepth=max(Proj.z-Depth,0.0);	
            if (Depth+Bias<Proj.z) Occlude +=1.0/(1.0+(zDepth*zDepth*0.01));
	   }
           Occlude=Occlude/16.0;
          #endif
         }
         return float4(0.5+Normals*0.5,pow(1.0-Occlude,Strength));
      }

//--------------
// techniques   
//--------------
   technique NormalsSSAO
      {
         pass p1
      {		
         VertexShader = compile vs_3_0 VS(); 
         PixelShader  = compile ps_3_0 PS();
         zwriteenable=false;
         zenable=false;
      }
      }
